/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.craftbukkit.entity;

import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class CraftCustomEntity
extends CraftEntity {
    private String entityName;

    public CraftCustomEntity(CraftServer server, Entity entity) {
        super(server, entity);
        if (this.entityName == null) {
            this.entityName = entity.m_7755_().getString();
        }
    }

    @Override
    public Entity getHandle() {
        return this.entity;
    }

    public LivingEntity asLivingEntity() {
        try {
            return (LivingEntity)this.entity;
        }
        catch (ClassCastException e) {
            System.err.println("Attempted to call asLivingEntity() on a non-LivingEntity entity");
            System.err.println("Entity name: " + this.entityName);
            System.err.println("Entity type: " + this.entity.m_6095_());
            System.err.println("Entity class: " + this.entity.getClass());
            return null;
        }
    }

    @Override
    @NotNull
    public EntityType getType() {
        EntityType type = EntityType.fromName(this.entityName);
        return type != null ? type : EntityType.UNKNOWN;
    }

    @Override
    public String toString() {
        return this.entityName;
    }

    @Override
    public String getCustomName() {
        String name = this.getHandle().m_7770_().getString();
        return name == null || name.length() == 0 ? this.entity.m_7755_().getString() : name;
    }
}

